function JToolbar(owner, parent, name)
{
	var self = this,
		_buttons = [],
		_formSelector;

	this.owner = owner;
	this.parent = parent;
	this.name = name;

	this.render = render;
	this.load = load;
	this.addButton = addButton;
	this.setFiltering = setFiltering;
	this.setRefresh = setRefresh;
	this.setSearching = setSearching;
	this.setSorting = setSorting;
	this.setSave = setSave;
	this.setPrinting = setPrinting;
	this.setNavigation = setNavigation;
	this.setRecordOperations = setRecordOperations;
	this.setInserting = setInserting;

	function render(fs)
	{
		fs.append('<span id="' + name + '" style="vertical-align: middle;">');
		fs.append('<button id="logout_btn" class="toolbarButton">Logout</button>');
		if (_buttons['rebuild'] != null) 
			fs.append('<button id="rebuild_btn" class="toolbarButton">' + _buttons['rebuild'].caption + '<img id="appRefreshImg" class="menuBarImg" border="0" src="" /></button>');
		if (_buttons['sortdlg'] != null) 
			fs.append('<button id="sortdlg_btn" class="toolbarButton">' + _buttons['sortdlg'].caption + '<img id="appSortImg" class="menuBarImg" src="" /></button>');
		if (_buttons['finddlg'] != null) 
			fs.append('<button id="finddlg_btn" class="toolbarButton">' + _buttons['finddlg'].caption + '<img id="appFindImg" class="menuBarImg" src="" /></button>');
		if (_buttons['filter_on'] != null) 
			fs.append('<button id="filter_on_btn" class="toolbarButton">' + _buttons['filter_on'].caption + '<img id="appFilterImg" class="menuBarImg" src="" /></button>');
		if (_buttons['filter_off'] != null) 
			fs.append('<button id="filter_off_btn" class="toolbarButton">' + _buttons['filter_off'].caption + '<img id="appNoFilterImg" class="menuBarImg" src="" /></button>');
		if (_buttons['save'] != null) 
			fs.append('<button id="save_btn" class="toolbarButton">' + _buttons['save'].caption + '<img id="appSaveRecImg" class="menuBarImg" src="" /></button>');
		if (_buttons['printdlg'] != null) 
			fs.append('<button id="printdlg_btn" class="toolbarButton">' + _buttons['printdlg'].caption + '<img id="appPrintdlgImg" class="menuBarImg" src="" /></button>');

		fs.append('<span id="app_formSelector" style="margin-left: 3;"></span>');
		fs.append('<div id="app_NavToolbar" style="padding-top:3;">');
		fs.append('<button id="NavFirstPage_btn" class="navToolbarButton"><img id="appNavFirstPage" class="menuBarImg" src="" /></button>');
		fs.append('<button id="NavPrevPage_btn" class="navToolbarButton"><img id="appNavPrevPage" class="menuBarImg" src="" /></button>');
		fs.append('<button id="NavPrevRec_btn" class="navToolbarButton"><img id="appNavPrevRec" class="menuBarImg" src="" /></button>');
		fs.append('<button id="NavNextRec_btn" class="navToolbarButton"><img id="appNavNextRec" class="menuBarImg" src="" /></button>');
		fs.append('<button id="NavNextPage_btn" class="navToolbarButton"><img id="appNavNextPage" class="menuBarImg" src="" /></button>');
		fs.append('<button id="NavLastPage_btn" class="navToolbarButton"><img id="appNavLastPage" class="menuBarImg" src="" /></button>');
		fs.append('<span id="app_NavToolbarRecordOps">'); 
		fs.append('<button id="NavNewRec_btn" class="navToolbarButton"><img id="appNavNewRec" class="menuBarImg" src="" style="padding:0; border:0" /></button>');
		fs.append('<button id="NavDelRec_btn" class="navToolbarButton"><img id="appNavDelRec" class="menuBarImg" src="" /></button>');
		fs.append('</span>');
		fs.append('<div id="' + self.name + '_dummy" style="width:5px"></div>');
		fs.append('</div>');
		fs.append('</span>');
 	}

	function load()
	{
		_loadImg('appRefreshImg', '6353,0');
		_loadImg('appSortImg', '6362,0');
		_loadImg('appFindImg', '6363,0');
		_loadImg('appFilterImg', '6364,0');
		_loadImg('appNoFilterImg', '6365,0');
		_loadImg('appSaveRecImg', '16761,10');
		_loadImg('appPrintdlgImg', '6444,0');

		_loadImg('appNavFirstPage', '6354,0');
		_loadImg('appNavPrevPage', '6442,0');
		_loadImg('appNavPrevRec', '6355,0');
		_loadImg('appNavNextRec', '6356,0');
		_loadImg('appNavNextPage', '6443,0');
		_loadImg('appNavLastPage', '6357,0');

		_loadImg('appNavNewRec', '6358,0');
		_loadImg('appNavDelRec', '6359,0', true);

		self.$$().onclick = click;
	}

	function checkEnabledState()
	{
		for (var btn in _buttons)
		{
			var btnObj = _buttons[btn]; 
			if (btnObj.enabled == 'none')
			{
				btnObj.set_enabled();
			}
		}

		checkbtnState('first',		'NavFirstPage_btn');
		checkbtnState('priorpage',	'NavPrevPage_btn');
		checkbtnState('prior',		'NavPrevRec_btn');
		checkbtnState('next',		'NavNextRec_btn');
		checkbtnState('nextpage',	'NavNextPage_btn');
		checkbtnState('last',		'NavLastPage_btn');
		checkbtnState('insert',		'NavNewRec_btn');
		checkbtnState('delete',		'NavDelRec_btn');
	}

	function checkbtnState(btnName, elemName)
	{
		if (_buttons[btnName].enabled == 'none')
			self.$(elemName).disabled = true;
	}

	function _loadImg(elemName, id, isLast)
	{
		var img = self.$(elemName);
		if ((img != null) && (img.getAttribute('__loaded') == null))
		{
			img.onload = function()
				{
					this.style.display = 'inline';
					this.__loaded = true;
					this.onload = null;
				}


			if (self.owner.isPortalVersion())
				img.src = self.owner.cgiPath() + '&act=getFuncIcon&cid=' + encodeURIComponent(self.owner.session) + '&id=' + id;
			else
				img.src = self.owner.cgiPath() + '?act=getFuncIcon&cid=' + encodeURIComponent(self.owner.session) + '&id=' + id;

			self.owner.addImage(elemName, img.src);
		}
	}


	function addButton(owner, parent, name, image, caption, hint, actionTarget, enabled)
	{
		_buttons[name] = new JToolButton(owner, parent, name, image, caption, hint, actionTarget, enabled);
	}

	function click(args)
	{
		var elem = utils.getEventElement(args);	
		if (elem.tagName.toLowerCase() == 'img')
			elem = elem.parentNode;

		if ((elem.tagName.toLowerCase() == 'button') && (!elem.disabled))
		{
			var action = elem.id;
			var idx = action.indexOf('_btn');
			if (idx > -1)
				action = action.substr(0, idx);
			
			self.owner.performAction(action);
		}

		if ((self.owner.activeForm) && (self.owner.activeForm.activeControl))
		{
		    if (self.owner.activeForm.activeControl.setFocus)
			{
				self.owner.activeForm.activeControl.setFocus();
			}
			else
			{
				var ctrl = self.owner.activeForm.activeControl.$$();
				if ((ctrl != null) && (ctrl.focus))
					try
					{
						ctrl.focus();
					}
					catch(ex)
					{}
			}
		}
	}

	function setFiltering(enabled)
	{
		_buttons['filter_on'].set_enabled(enabled);
		_buttons['filter_off'].set_enabled(enabled);
	}

	function setRefresh(enabled)
	{
		_buttons['rebuild'].set_enabled(enabled);
	}

	function setSearching(enabled)
	{
		_buttons['finddlg'].set_enabled(enabled);
	}

	function setSorting(enabled)
	{
		_buttons['sortdlg'].set_enabled(enabled);
	}

	function setSave(enabled)
	{
		_buttons['save'].set_enabled(enabled);
	}

	function setPrinting(enabled)
	{
		_buttons['printdlg'].set_enabled(enabled);
	}

	function setNavigation(enabled)
	{
		self.$('app_NavToolbar').style.display = enabled;
	}
	
	function setInserting(enabled)
	{
		_buttons['insert'].set_enabled(enabled);
	}
	
	function setRecordOperations(enabled)
	{
//			self.$('app_NavToolbarRecordOps').style.display = (enabled) ? "" : "none";
			self.$('app_NavToolbarRecordOps').style.display = "none";
	}
}

JToolbar.inheritsFrom(ControlBase);


function JToolButton(owner, parent, name, image, caption, hint, actionTarget, enabled)
{
	var self = this;

	this.owner = owner;
	this.parent = parent;
	this.name = name;
	this.image = image;
	this.caption = caption;
	this.hint = hint;
	this.actionTarget = actionTarget;
	this.enabled = enabled;

	this.set_enabled = set_enabled;
	this.enable = this.disable = function (){ };

	self.owner.registerObject(name, self);

	function set_enabled(value)
	{
		if (enabled == 'none')
			value = false;

		var elem = self.owner.$(self.name + '_btn');
		if (elem != null)
			elem.disabled = !value;
	}
} 

if (typeof(loadNextScript) != 'undefined')
	loadNextScript();
